var Template = new Class({
  directory: "templates",
  text: "",
  xml: null,

  initialize: function(name){
    this.loadFile(name);
    this.loadXML();
  },
  
  loadFile: function(name){
    var file = air.File.applicationDirectory.resolvePath(this.directory+"/"+name+".html");
    if(!file.exists){
			showError('Error: section file not found');
			return false;
		} 
    var fs = new air.FileStream();
    fs.open(file, air.FileMode.READ);
    this.text = fs.readMultiByte(file.size, "utf-8");
    fs.close();
    return this;
  },
  
  loadXML: function(){
    e = new Element("div");
    e.innerHTML = this.text;
    this.xml = e.getChildren();
    return this;
  }
});